/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.block;

import de.cristelknight.doapi.common.block.StorageBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import satisfyu.candlelight.registry.StorageTypesRegistry;
import satisfyu.candlelight.util.CandlelightGeneralUtil;

public class ShelfBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.1875, (double)0.625, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.1875, (double)0.625, (double)0.875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0625, (double)0.9375, (double)0.875, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, CandlelightGeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public ShelfBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        BlockState blockState = side != Direction.DOWN && side != Direction.UP ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_43719_()) : (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        if (blockState.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) {
            return blockState;
        }
        return null;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41614_() || stack.m_41720_() instanceof BlockItem;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public int size() {
        return 9;
    }

    public ResourceLocation type() {
        return StorageTypesRegistry.SHELF;
    }

    public int getSection(Float f, Float y) {
        float oneS = 0.11111111f;
        int nSection = (int)(f.floatValue() / oneS);
        return 8 - nSection;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape;
        return Block.m_49918_((VoxelShape)shape, (Direction)(switch (((Direction)state.m_61143_((Property)f_54117_)).m_122424_()) {
            case Direction.EAST -> {
                shape = world.m_8055_(pos.m_122029_()).m_60808_((BlockGetter)world, pos.m_122029_());
                yield Direction.WEST;
            }
            case Direction.SOUTH -> {
                shape = world.m_8055_(pos.m_122019_()).m_60808_((BlockGetter)world, pos.m_122019_());
                yield Direction.NORTH;
            }
            case Direction.WEST -> {
                shape = world.m_8055_(pos.m_122024_()).m_60808_((BlockGetter)world, pos.m_122024_());
                yield Direction.EAST;
            }
            default -> {
                shape = world.m_8055_(pos.m_122012_()).m_60808_((BlockGetter)world, pos.m_122012_());
                yield Direction.SOUTH;
            }
        }));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

